/*
 * Decompiled with CFR 0.152.
 */
package PSG_Emu;

import PSG_Emu.PSG_Chip;
import PSG_Emu.SoundTable;
import java.text.NumberFormat;

public class OS7_PSG_Driver {
    private PSG_Chip chip;
    private int down_sampling;
    private float f_sample_rate;
    byte[] channel = new byte[4];
    int[] i_initial_period = new int[4];
    byte[] b_initial_attenuation = new byte[4];
    boolean[] is_attenuation_swept_note = new boolean[4];
    byte[] b_attenuation_step = new byte[4];
    int[] i_numberof_attenuation_step = new int[4];
    int[] i_attenuation_step_length = new int[4];
    int[] i_first_attenuation_step_length = new int[4];
    boolean[] is_period_swept_note = new boolean[4];
    int[] i_numberof_period_step = new int[4];
    int[] i_period_step = new int[4];
    int[] i_period_step_length = new int[4];
    int[] i_first_period_step_length = new int[4];
    byte b_noise_code;
    byte b_current_noise_code;
    int[] i_actual_period = new int[4];
    byte[] b_actual_attenuation = new byte[4];
    int[] i_actual_period_step_length = new int[4];
    int[] i_actual_attenuation_step_length = new int[4];
    int[] i_length_note = new int[4];
    int[] i_soundfx_pointer = new int[4];
    boolean[] b_endofsoundtable = new boolean[4];
    public static String[] noisefreqs = new String[]{"periodic noise - freq 499 Hz", "periodic noise - freq 249 Hz", "periodic noise - freq 125 Hz", "periodic noise - freq channel 3", "white noise - freq 3495 Hz", "white noise - freq 1748 Hz", "white noise - freq 874 Hz", "white noise - freq channel 3"};

    public OS7_PSG_Driver() {
        this.chip = new PSG_Chip();
    }

    private int if0then16(int n) {
        if (n == 0) {
            return 16;
        }
        return n;
    }

    public void load_next_note(SoundTable soundTable, int n) {
        if (this.i_soundfx_pointer[n] >= soundTable.get_table_length(n)) {
            return;
        }
        byte[] byArray = soundTable.get_table(n);
        int n2 = n;
        int n3 = this.i_soundfx_pointer[n2];
        this.i_soundfx_pointer[n2] = n3 + 1;
        int n4 = byArray[n3];
        if (n4 == 255) {
            n4 = 16;
        }
        int n5 = n4;
        n5 = (byte)(n5 >>> 6);
        n5 = (byte)(n5 & 3);
        if (this.channel[n] == -1) {
            this.channel[n] = n5;
        }
        if (((n4 = (int)((byte)(n4 & 0x3F))) & 0x20) == 32) {
            this.i_length_note[n] = n4;
            int n6 = n;
            this.i_length_note[n6] = this.i_length_note[n6] & 0x1F;
            if (this.i_length_note[n] == 0) {
                this.i_length_note[n] = 256;
            }
            this.is_attenuation_swept_note[n] = false;
            this.is_period_swept_note[n] = false;
            this.b_actual_attenuation[n] = 15;
        } else {
            this.channel[n] = n5;
            switch (n4 & 0x3F) {
                case 0: {
                    if (this.channel[n] == 0) {
                        int n7 = n;
                        this.i_soundfx_pointer[n7] = this.i_soundfx_pointer[n7] + 1;
                    }
                }
                case 2: {
                    if (this.channel[n] == 0) {
                        this.b_noise_code = byArray[this.i_soundfx_pointer[n]];
                        this.b_noise_code = (byte)(this.b_noise_code & 7);
                    }
                }
                case 1: 
                case 3: {
                    if (this.channel[n] != 0) {
                        this.i_initial_period[n] = byArray[this.i_soundfx_pointer[n] + 1];
                        int n8 = n;
                        this.i_initial_period[n8] = this.i_initial_period[n8] & 3;
                        int n9 = n;
                        this.i_initial_period[n9] = this.i_initial_period[n9] << 8;
                        int n10 = n;
                        int n11 = this.i_soundfx_pointer[n10];
                        this.i_soundfx_pointer[n10] = n11 + 1;
                        int n12 = byArray[n11];
                        int n13 = n;
                        this.i_initial_period[n13] = this.i_initial_period[n13] | (n12 &= 0xFF);
                    }
                    int n14 = n;
                    int n15 = this.i_soundfx_pointer[n14];
                    this.i_soundfx_pointer[n14] = n15 + 1;
                    this.b_initial_attenuation[n] = byArray[n15];
                    int n16 = n;
                    this.b_initial_attenuation[n16] = (byte)(this.b_initial_attenuation[n16] >>> 4);
                    int n17 = n;
                    this.b_initial_attenuation[n17] = (byte)(this.b_initial_attenuation[n17] & 0xF);
                    int n18 = n;
                    int n19 = this.i_soundfx_pointer[n18];
                    this.i_soundfx_pointer[n18] = n19 + 1;
                    this.i_length_note[n] = byArray[n19];
                    int n20 = n;
                    this.i_length_note[n20] = this.i_length_note[n20] & 0xFF;
                    if (this.i_length_note[n] == 0) {
                        this.i_length_note[n] = 256;
                    }
                    if ((n4 & 1) == 1) {
                        this.i_numberof_period_step[n] = this.i_length_note[n];
                        this.i_period_step_length[n] = byArray[this.i_soundfx_pointer[n]];
                        int n21 = n;
                        this.i_period_step_length[n21] = this.i_period_step_length[n21] >>> 4;
                        int n22 = n;
                        this.i_period_step_length[n22] = this.i_period_step_length[n22] & 0xF;
                        this.i_period_step_length[n] = this.if0then16(this.i_period_step_length[n]);
                        int n23 = n;
                        int n24 = this.i_soundfx_pointer[n23];
                        this.i_soundfx_pointer[n23] = n24 + 1;
                        this.i_first_period_step_length[n] = byArray[n24];
                        int n25 = n;
                        this.i_first_period_step_length[n25] = this.i_first_period_step_length[n25] & 0xF;
                        this.i_first_period_step_length[n] = this.if0then16(this.i_first_period_step_length[n]);
                        int n26 = n;
                        int n27 = this.i_soundfx_pointer[n26];
                        this.i_soundfx_pointer[n26] = n27 + 1;
                        this.i_period_step[n] = byArray[n27];
                        if (this.i_period_step[n] != 0) {
                            this.i_length_note[n] = this.i_first_period_step_length[n] + this.i_period_step_length[n] * (this.i_numberof_period_step[n] - 1);
                            this.i_actual_period_step_length[n] = this.i_first_period_step_length[n];
                            this.is_period_swept_note[n] = true;
                        } else {
                            this.is_period_swept_note[n] = false;
                        }
                    } else {
                        this.is_period_swept_note[n] = false;
                    }
                    if ((n4 & 2) == 2) {
                        this.b_attenuation_step[n] = byArray[this.i_soundfx_pointer[n]];
                        int n28 = n;
                        this.b_attenuation_step[n28] = (byte)(this.b_attenuation_step[n28] >> 4);
                        int n29 = n;
                        int n30 = this.i_soundfx_pointer[n29];
                        this.i_soundfx_pointer[n29] = n30 + 1;
                        this.i_numberof_attenuation_step[n] = byArray[n30];
                        int n31 = n;
                        this.i_numberof_attenuation_step[n31] = this.i_numberof_attenuation_step[n31] & 0xF;
                        this.i_numberof_attenuation_step[n] = this.if0then16(this.i_numberof_attenuation_step[n]);
                        this.i_attenuation_step_length[n] = byArray[this.i_soundfx_pointer[n]];
                        int n32 = n;
                        this.i_attenuation_step_length[n32] = this.i_attenuation_step_length[n32] >>> 4;
                        int n33 = n;
                        this.i_attenuation_step_length[n33] = this.i_attenuation_step_length[n33] & 0xF;
                        this.i_attenuation_step_length[n] = this.if0then16(this.i_attenuation_step_length[n]);
                        int n34 = n;
                        int n35 = this.i_soundfx_pointer[n34];
                        this.i_soundfx_pointer[n34] = n35 + 1;
                        this.i_first_attenuation_step_length[n] = byArray[n35];
                        int n36 = n;
                        this.i_first_attenuation_step_length[n36] = this.i_first_attenuation_step_length[n36] & 0xF;
                        this.i_first_attenuation_step_length[n] = this.if0then16(this.i_first_attenuation_step_length[n]);
                        this.i_actual_attenuation_step_length[n] = this.i_first_attenuation_step_length[n];
                        this.is_attenuation_swept_note[n] = true;
                    } else {
                        this.is_attenuation_swept_note[n] = false;
                    }
                    this.i_actual_period[n] = this.i_initial_period[n];
                    this.b_actual_attenuation[n] = this.b_initial_attenuation[n];
                    break;
                }
                case 4: {
                    int n37 = n;
                    this.i_soundfx_pointer[n37] = this.i_soundfx_pointer[n37] + 1;
                    break;
                }
                case 24: {
                    this.i_soundfx_pointer[n] = 0;
                    this.load_next_note(soundTable, n);
                }
                default: {
                    this.b_endofsoundtable[n] = true;
                }
            }
        }
    }

    public void generate(SoundTable soundTable) {
        int n;
        boolean bl = false;
        int n2 = soundTable.numberOfTable();
        boolean bl2 = false;
        this.b_noise_code = (byte)9;
        this.chip.initialize_chip();
        this.chip.clear_stream();
        this.chip.mute();
        for (n = 0; n < n2; ++n) {
            this.channel[n] = -1;
            this.b_endofsoundtable[n] = false;
            this.is_attenuation_swept_note[n] = false;
            this.is_period_swept_note[n] = false;
            this.i_soundfx_pointer[n] = 0;
            this.channel[n] = 0;
            this.load_next_note(soundTable, n);
        }
        while (!bl) {
            this.chip.mute();
            bl = true;
            for (n = 0; n < n2; ++n) {
                bl &= this.b_endofsoundtable[n];
                if (this.i_length_note[n] <= 0) continue;
                int n3 = n;
                this.i_length_note[n3] = this.i_length_note[n3] - 1;
                if (this.channel[n] > 0) {
                    this.chip.tone(this.channel[n], this.i_actual_period[n], this.b_actual_attenuation[n]);
                } else {
                    this.chip.noise(this.b_noise_code, this.b_actual_attenuation[n]);
                }
                if (this.i_length_note[n] == 0) {
                    this.load_next_note(soundTable, n);
                    continue;
                }
                if (this.is_attenuation_swept_note[n]) {
                    if (this.i_actual_attenuation_step_length[n] > 1) {
                        int n4 = n;
                        this.i_actual_attenuation_step_length[n4] = this.i_actual_attenuation_step_length[n4] - 1;
                    } else if (this.i_numberof_attenuation_step[n] > 1) {
                        int n5 = n;
                        this.i_numberof_attenuation_step[n5] = this.i_numberof_attenuation_step[n5] - 1;
                        this.i_actual_attenuation_step_length[n] = this.i_attenuation_step_length[n];
                        int n6 = n;
                        this.b_actual_attenuation[n6] = (byte)(this.b_actual_attenuation[n6] + this.b_attenuation_step[n]);
                        int n7 = n;
                        this.b_actual_attenuation[n7] = (byte)(this.b_actual_attenuation[n7] & 0xF);
                    } else {
                        this.is_attenuation_swept_note[n] = false;
                    }
                }
                if (!this.is_period_swept_note[n]) continue;
                if (this.i_actual_period_step_length[n] > 1) {
                    int n8 = n;
                    this.i_actual_period_step_length[n8] = this.i_actual_period_step_length[n8] - 1;
                    continue;
                }
                this.i_actual_period_step_length[n] = this.i_period_step_length[n];
                int n9 = n;
                this.i_actual_period[n9] = this.i_actual_period[n9] + this.i_period_step[n];
                int n10 = n;
                this.i_actual_period[n10] = this.i_actual_period[n10] & 0x3FF;
            }
            if (bl) continue;
            this.chip.refresh(true);
        }
    }

    public void play() {
        this.chip.start_playing();
    }

    public void stop() {
        this.chip.stop_playing();
    }

    public void kill() {
        this.chip.kill();
    }

    public String comments(SoundTable soundTable) {
        String string = new String();
        int n = soundTable.numberOfTable();
        boolean bl = false;
        this.b_noise_code = (byte)9;
        for (int i = 0; i < n; ++i) {
            this.channel[i] = -1;
            this.b_endofsoundtable[i] = false;
            this.is_attenuation_swept_note[i] = false;
            this.is_period_swept_note[i] = false;
            this.i_soundfx_pointer[i] = 0;
            this.channel[i] = 0;
            int n2 = 0;
            while (!this.b_endofsoundtable[i]) {
                this.load_next_note(soundTable, i);
                if (this.b_endofsoundtable[i]) {
                    if (this.i_soundfx_pointer[i] <= n2) {
                        string = string + "1:repeat";
                        continue;
                    }
                    string = string + "1:end";
                    continue;
                }
                int n3 = this.i_soundfx_pointer[i] - n2;
                n2 = this.i_soundfx_pointer[i];
                string = string + String.valueOf(n3).concat(":");
                if (!this.is_period_swept_note[i] && !this.is_attenuation_swept_note[i] && this.b_actual_attenuation[i] == 15) {
                    string = string + "rest";
                } else {
                    if (this.channel[i] == 0) {
                        string = string + noisefreqs[this.b_noise_code & 7];
                    } else {
                        string = string + "tone ";
                        string = string + "freq ";
                        string = string + this.valueOfPeriod(this.i_actual_period[i]);
                        string = string + "Hz";
                    }
                    if (this.is_period_swept_note[i]) {
                        if (this.i_period_step[i] > 0) {
                            string = string + " swept down";
                        } else if (this.i_period_step[i] < 0) {
                            string = string + " swept up";
                        }
                    }
                    string = string + " - vol ";
                    string = this.b_actual_attenuation[i] == 15 ? string + "0 (off)" : (this.b_actual_attenuation[i] == 0 ? string + "15 (max)" : string + String.valueOf(15 - this.b_actual_attenuation[i]));
                    if (this.is_attenuation_swept_note[i]) {
                        if (this.b_attenuation_step[i] > 0) {
                            string = string + " swept down";
                        } else if (this.b_attenuation_step[i] < 0) {
                            string = string + " swept up";
                        }
                    }
                }
                string = string + " - length ";
                string = string + String.valueOf(this.i_length_note[i]);
                string = string + ";";
            }
            if (i == n - 1) continue;
            string = string + "|";
        }
        return string;
    }

    private String valueOfPeriod(int n) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setGroupingUsed(false);
        numberFormat.setMaximumFractionDigits(1);
        numberFormat.setMinimumFractionDigits(1);
        double d = 111860.796875;
        return numberFormat.format(d /= (double)n);
    }
}

